/*
 * @(#)StructTableModel.java  1.1  2000-09-29
 *
 * Copyright (c) 2000 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of 
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */
package ch.randelshofer.media.binary;

import javax.swing.table.AbstractTableModel;
import java.util.Vector;

/**
 * Table model for structured binary data.
 *
 * @author  Werner Randelshofer, Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * @version 1.1   2000-09-29
 * <br>1.0  2000-06-12
 */
public class StructTableModel extends AbstractTableModel {
    Vector data;
    StructParser.TypedefDeclaration typedef;
    private final char[] HEX = { '0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f' };

    /**
     * Vector provides the data of the model.
     * Even entries are represented by the first column of the table.
     * Odd entries are represented by the second column of the table.
     */
    public StructTableModel(StructParser.TypedefDeclaration typedef, Vector data) {
        this.typedef = typedef;
        this.data = data;
    }

    public int getRowCount() {
        return data.size();
    }
    public int getColumnCount() {
        return 2;
    }
    public Object getValueAt(int row, int column) {
        StructTableModel.Value elem = (StructTableModel.Value) data.elementAt(row);
        Object value;
        if (column == 0) {
            value = identifierToString(((elem.index == null) ? elem.declaration : elem.declaration+elem.index).toString());
        } else {
            value = elem.value;
        }
        return value;
    }

    public static String identifierToString(String s) {
        StringBuffer b = new StringBuffer();
        b.append(Character.toUpperCase(s.charAt(0)));
        for (int i=1; i < s.length(); i++) {
            if (Character.isUpperCase(s.charAt(i))) {
                b.append(' ');
            }
            b.append(s.charAt(i));
        }
        return b.toString();
    }

    public String getColumnName(int column) {
        return (column == 0) ? "Name" : "Value";
    }
    /**
     * Represents one typed value of the data structure represented by the StructTableModel.
     */
    public static class Value {
        public Object declaration;
        public String index;
        public Object value;
    }

    public String toString() {
        return (typedef != null) ? typedef.toString() : super.toString();
    }
}

